<?php
class SliceRepository extends EntityRepository {

    private $table = 'slices';
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null) {             
        $data['status'] = '1';     
        if(trim($data['price'])=='' || is_null($data['price'])){$data['price'] = 0;}
        if($data['id']==null || $data['id']==''){unset($data['id']);}
               
        return parent::save($data, $this->table);        
      
    }
    
    public function delete($id, $table = null) {
        //return parent::delete($id, $this->table);
        return parent::update($id, array('status'=>'2'), $this->table);
    }

    public function update($id, $data, $table = null) {        
        if(trim($data['status']) == ''){unset($data['status']);}
        return parent::update($id, $data, $this->table);                
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'status','slice')as statusName, "
                . "fxGetUserName(creado_por) as userName, "
                . "fxGetTamanoDescripcion(size) as sizeName, "
                . "fxGetCategoriaDescripcion(category) as categoryName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('compras' => 'id')," AND status = 2 AND (type != 'BienesyServicios' AND type != 'Consigna' AND type != 'MateriaPrima')");
    }
    
    public function getListSlice(){
        $query = "SELECT c.*,
                fxGetStatusName(c.`status`,'status','slice')as statusName,
                fxGetCategoriaDescripcion(c.category)as categoryName,
                fxGetTamanoDescripcion(c.size)as sizeName
                FROM slices c
                WHERE  1=1 " 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";
    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
   public function getListSelectSlice($category = null){
        if($category != null){$category = " AND c.category = '$category'";}
        $query = "SELECT c.*,
                fxGetStatusName(c.`status`,'status','slice')as statusName,
                fxGetCategoriaDescripcion(c.category)as categoryName,
                fxGetTamanoDescripcion(c.size)as sizeName
                FROM slices c
                WHERE  1=1 $category "
              . "AND status = '1' " 
              . "GROUP BY c.id "
              . "ORDER BY c.flavor ASC ";
    
        $result = $this->query($query);
        
       if ($result->num_rows > 0) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['flavor']." ".$row['sizeName'];
            }
            return $array;
        }
        return null;
    }
}