<?php
class MainServerEntityRepository {
    private $id;
    private $lastInsertId = null;
    
    protected $_options = array();

    public function setId($id) {
        $this->id = $id;
    }

    public function getId() {
        return $this->id;
    }
    
    public function delete($id,$table){
        $select = "DELETE  FROM $table WHERE id = $id";
        $result = $this->query($select);
        
        if($result){
            return true;
        }        
        return null;
    }

    public function save(array $data, $table) {
        $select = "INSERT INTO $table";
        $fields = "";
        $values = "";
        foreach ($data as $key => $value) {           
            if(!is_array($value)){
                $fields .= "$key,";
                $value = mysqli_real_escape_string(DBMainServer::getInstance(),$value);
                $values .= "'$value',";
            }else{         
                $fields .= "{$value['key']},";
                $value['value'] = mysqli_real_escape_string(DBMainServer::getInstance(),$value['value']);
                $values .= "{$value['value']},";
            }            
            
        }
        $fields = substr($fields, 0, strlen($fields) - 1);
        $values = substr($values, 0, strlen($values) - 1);

        $select = $select . "(" . $fields . ") VALUES (" . $values . ")";
 
        return $this->query($select);        
    }
    
    public function getInsertId(){
        return DBMainServer::getInsertId();
    }
    
    public function setLastInsertId($id){
        $this->lastInsertId = $id;
    }
    
    public function getLastInsertId(){
        return $this->lastInsertId;
    }

    public function update($id, $fields, $table) {
        //var_dump($fields);
        $select = "UPDATE $table SET ";
        foreach ($fields as $key => $value) {
            if(!is_array($value)){
                $value = mysqli_real_escape_string(DBMainServer::getInstance(),$value);
                $select .= "$key = '$value',";
            }else{                
                $value['value'] = mysqli_real_escape_string(DBMainServer::getInstance(),$value['value']);
                $select .= "{$value['key']} = {$value['value']},";
            }            
        }

        $select = substr($select, 0, strlen($select) - 1);
        $select .= " WHERE id = $id";
        //echo $select;exit;
        return  $this->query($select);
    }
    
    public function updateString($fields,$where,$table) {
        $select = "UPDATE $table SET ";
        foreach ($fields as $key => $value) {
            $select .= "$key = '$value',";
        }

        $select = substr($select, 0, strlen($select) - 1);
        $select .= " WHERE ".$where;
        return  $this->query($select);
    }

    public function getById($id, $table,$selectAux = null) {
        $select = "SELECT * ";
        if($selectAux){$select .= ",$selectAux";}
        
        $select = "$select FROM $table WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return null;
    }
    
    public function isUsedInRecord($id,array $buscarEn, $andWhere = null){
        foreach($buscarEn as $key => $value){
            $select = "SELECT id FROM $key WHERE $value = '$id' $andWhere limit 1";
            $result = $this->query($select);
            if($result->num_rows > 0){
                $result = $result->fetch_object();
                return array('id'=>$result->id,'table'=>$key);
            }
        }
        
        return null;
    }
    
    public function query($query){
        $result = DBMainServer::getInstance()->execute($query);
        return $result;
    }
    
    public function resultToArray($result){
        for ($set = array(); $row = $result->fetch_assoc(); $set[] = $row);
  
        return $set;
    }
    
    public function startTransaction(){
        return $this->query('START TRANSACTION');
    }
    
    public function commit(){
        return $this->query('COMMIT');
    }
    
    public function rollback(){
        return $this->query('ROLLBACK');
    }
}

