<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class ImpuestosRepository extends EntityRepository {

    private $table = ' impuestos';

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();
        $data['status'] = 1;
        unset($data['modificaciones']);

        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null) {        
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {
        unset($data['creado_fecha'],$data['creado_por'],$data['status'],$data['modificaciones']);
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('productos' => 'tamano'));
    }

    public function getListaSelectImpuestos() {
        $select = "SELECT * FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['impuesto']." - ".$row['impuestos_tasa']." %";
            }
            return $array;
        }
        return null;
    }
    
     public function getListaImpuestos() {
        $select = "SELECT * from $this->table ";
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getInfoImpuestos(){
        $query = "SELECT * FROM $this->table ORDER BY id ASC";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $impuestos = array();
            foreach($this->resultToArray($result) as $impuesto){
                $impuestos[$impuesto['id']] = $impuesto;
            }
            return $impuestos;
        }        
        return null;
    }
}
