<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class AperturaCierreCajaRepository extends EntityRepository {

    private $table = 'apertura_cierre_cajas';
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null) {
        
        $login = new Login();
        $data['fechaApertura'] = date('Y-m-d H:i:s');
        $data['efectivoFinal'] = '0';
        $data['tarjetasFinal'] = '0';
        $data['chequesFinal'] = '0';
        $data['electronicoFinal'] = '0';
        $data['devoluciones'] = '0';
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        $data['creado_por'] = $login->getId();
        $data['status'] = 1;
        
        if(isset($data['autorizacion_usuario'])){
            if(!$this->autorizacionValida($data['autorizacion_usuario'],$data['autorizacion_password'])){
                $this->flashmessenger->addMessage(array('info'=>'Autorizacion invalida'));
                return null;
                /* Raevisar porque se queda en blanco pagina*/
            }
        }
        unset($data['devoluciones'],$data['fechaCierre'],$data['autorizacion_usuario'],$data['autorizacion_password']);
        
        if($data['efectivoInicial'] === null OR trim($data['efectivoInicial']) =='' ){$data['efectivoInicial'] = '0';}
        
        $result = parent::save($data, $this->table);
        if($result){
            $this->setLastInsertId($this->getInsertId());
            return true;
        }
        return null;
    }
    
    public function autorizacionValida($usuario,$contrasena){
        $query = "SELECT id FROM usuarios WHERE usuario = '$usuario' AND contrasena = MD5('$contrasena')";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return true;
        }
        return null;
    }
    
    public function delete($id, $table = null) {        
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {
        if(isset($data['autorizacion_usuario'])){
            if(!$this->autorizacionValida($data['autorizacion_usuario'],$data['autorizacion_password'])){
                $this->flashmessenger->addMessage(array('info'=>'Autorizacion invalida'));
                return null;
                /* Raevisar porque se queda en blanco pagina*/
            }
        }
        unset($data['autorizacion_usuario'],$data['autorizacion_password']);        
        unset($data['devoluciones'],$data['fechaApertura'],$data['fechaCierre'],$data['status'],$data['creado_fecha'],$data['creado_por'],$data['modificaciones']);
        
        if($data['efectivoInicial'] === null OR trim($data['efectivoInicial']) =='' ){$data['efectivoInicial'] = '0';}
        if($data['efectivoFinal'] === null OR trim($data['efectivoFinal']) =='' ){$data['efectivoFinal'] = '0';}
        if($data['chequesFinal'] === null OR trim($data['chequesFinal']) =='' ){$data['chequesFinal'] = '0';}
        if($data['tarjetasFinal'] === null OR trim($data['tarjetasFinal']) =='' ){$data['tarjetasFinal'] = '0';}
        
        return parent::update($id, $data, $this->table);
    }
    
    public function cerrar($id, $data, $table = null) {
        unset(  
                $data['fechaApertura'],
                $data['idCaja'],
                $data['efectivoInicial'],
                $data['creado_fecha'],
                $data['creado_por'],
                $data['modificaciones']
            );
        
        if(isset($data['autorizacion_usuario'])){
            if(!$this->autorizacionValida($data['autorizacion_usuario'],$data['autorizacion_password'])){
                $this->flashmessenger->addMessage(array('info'=>'Autorizacion invalida'));
                return null;
            }
        }
        
        unset($data['autorizacion_usuario'],$data['autorizacion_password']);   
        $data['status'] = 2;
        $data['fechaCierre'] = date('Y-m-d H:i:s');
        
        if($data['efectivoFinal'] === null OR trim($data['efectivoFinal']) =='' ){$data['efectivoFinal'] = '0';}
        if($data['chequesFinal'] === null OR trim($data['chequesFinal']) =='' ){$data['chequesFinal'] = '0';}
        if($data['tarjetasFinal'] === null OR trim($data['tarjetasFinal']) =='' ){$data['tarjetasFinal'] = '0';}
        if($data['devoluciones'] === null OR trim($data['devoluciones']) =='' ){$data['devoluciones'] = '0';}
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id,$table = null,$selectAux = null) {
        $query = "SELECT apc.*,"
                . "e.nombre as cajaName,"
                . "fxGetUserName(apc.creado_por)as usuarioName,"
                . "e.token "
                . "FROM $this->table apc, estaciones e "
                . "WHERE apc.idCaja = e.id "
                . "AND apc.id = '$id'";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }
        
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('productos' => 'marca'));
    }

    public function getListaSelectCajas() {
        $select = "SELECT * FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListaCajas() {
        $login = new Login();
        $andSucursal = null;
        if($login->getRole() === '2'){
            $andSucursal = " AND e.sucursal = '{$login->getSucursal()}' AND a.idCaja = '{$login->getIdCaja()}' ";
        }
        
        $select = "SELECT a.*,"
                . "DATE_FORMAT(a.fechaApertura,'%b/%d/%Y %T')as fechaAperturaFormateada,"
                . "fxGetStatusName(a.status,'status','caja')as statusName,"
                . "fxGetCajaName(a.idCaja)as caja,"
                . "efectivoInicial as efectivoInicial,"
                . "IF(a.status = 1,'-',SUM(a.efectivoFinal + a.tarjetasFinal + a.chequesFinal))as saldoFinal "
                . "from $this->table a left join estaciones e ON a.idCaja = e.id "
                . "WHERE 1 =1 "
                . $andSucursal
                . "GROUP BY a.id "
                . "ORDER BY a.id DESC"; 
        $result = $this->query($select);

        if ($result->num_rows > 0) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus(){
        $query = "SELECT * FROM codigo_status WHERE tipo = 'estacion'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            foreach($result as $status){
                $array[$status['codigo']] = $status['descripcion'];
            }
            return $array;
        }
        return null;
    }
    
    public function getListEstacionesCajas($idAperturaCierre = null) {    
        $login = new Login();
        $query = "SELECT id,nombre FROM estaciones WHERE tipo = '1' AND sucursal = '{$login->getSucursal()}' ";
        $result = $this->query($query);
        
        $cajas = array();
        if($result->num_rows > 0){
            foreach($result as $row){
                $cajas[$row['id']] = $row['nombre'];
            }
        }        
        
        $or = null;
        if($idAperturaCierre){ $or = " OR id = '$idAperturaCierre'";}
        $query = "SELECT * FROM apertura_cierre_cajas WHERE status = '1' $or";
        $result = $this->query($query);
        if ($result->num_rows > 0) {
            $idCajaEditando = null;
            $cajasOrigin = $cajas;
            
            foreach($result as $row){           
                if($row['id'] == $idAperturaCierre){$idCajaEditando = $row['idCaja'];}
                unset($cajas[$row['idCaja']]); 
            }
            if($idCajaEditando){
                $cajas[$idCajaEditando] = $cajasOrigin[$idCajaEditando]; 
            }
        }
        return $cajas;
    }
    
    public function cajaAbiertaById($idCaja){
       $query = "SELECT acc.id "
               . "FROM apertura_cierre_cajas acc,estaciones e "
               . "WHERE acc.idCaja = e.id "
               . "AND acc.id = '$idCaja' AND acc.status = '1'";
       $result = $this->query($query);
       
       if($result->num_rows > 0){
           return true;
       }
       return null;
   }  
   
   public function getAperturaActualByIdCaja(){
       $login = new Login();
       $query = "SELECT id "
              . "FROM $this->table "
              . "WHERE idCaja = '{$login->getIdCaja()}' "
              . "AND status = '1' "
              . "ORDER BY id DESC "                
              . "LIMIT 1 ";
              
        $result = $this->query($query);
              
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->id;
        }
       return null;
   }
}