<?php  
class InvoicePDF {
    private $pathInvoiceCreated = null; 
    public function __construct($idVenta,$createFile = null) {
        $venta = new VentaEntity();
        $venta->setOptions($venta->getById($idVenta));
        $ventaData = $venta->getInfoReal();
        $ventaDetalles = $venta->getDetallesInfoReal($idVenta);
        
        $cliente = new ClienteEntity();
        $cliente->setOptions($cliente->getById($venta->getCliente()));        
        $cliente->setId($venta->getCliente());
        
        $empresa = new EmpresaRepository();
        $empresaData = $empresa->getById(1);        
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php 
        $pdf = new PDF();
        if($ventaData['Status']=='3'){
            $pdf->AddPage('','','   V o i d');
        }elseif($ventaData['Status'] == '2'){
            $pdf->AddPage('','','   P a i d');
        }else{
            $pdf->AddPage('','');
        }
        
        $pdf->SetFillColor(200,200,200);
        $pdf->Image(ROOT."/public/img/logo.png",10,10,80,0);
        $pdf->Image(ROOT."/public/img/grapeApp.png",170,275,30,0);
        
        $pdf->SetFont('Arial','B','20');
        $pdf->SetTextColor(128);
        $pdf->Cell(135, 20, "", '0', 0, 'R'); //<== margin left   
        $pdf->Cell(50, 20, "INVOICE", '0', 1, 'C');    
        
        $pdf->Ln(1);
        $pdf->SetFont('Arial','B','12');
        $pdf->SetTextColor(0);
        $pdf->Cell(120, 8, $empresaData['nombre'], '0', 1, 'L');
        
        $pdf->SetFont('Arial','','12');
        $direccion = $empresaData['direccion']."\n";
        $direccion .= $empresaData['ciudad'].", ".$empresaData['estado']." ".$empresaData['codigopostal']."\n";
        if(trim($empresaData['telefonos'])!=''){$direccion .= "Phone: ".$empresaData['telefonos']."\n";}
        if(trim($empresaData['fax'])!=''){$direccion .= "Fax: ".$empresaData['fax']."\n";}
        if(trim($empresaData['email'])!=''){$direccion .= "Email: ".$empresaData['email']."\n";}
        $direccion .= "Sales Rep: ".$ventaData['vendedor'];
        $pdf->Cell(70, 28, $direccion, '0', 0, 'L');
        
        $pdf->Cell(50, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Invoice #", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, $ventaData['Venta'], '1', 1, 'C');
        
        $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Date", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, $ventaData['Fecha'], '1', 1, 'C');
        
        $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Terms", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $terms = '';
        if(trim($ventaData['diasCredito']) != ''){$terms = $ventaData['diasCredito']." days";}
        $pdf->Cell(25, 5, $terms, '1', 1, 'C');
        
         $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Due date", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, $ventaData['FechaPago'], '1', 1, 'C');
        
        $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Customer PO#", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, $ventaData['PO'], '1', 1, 'C');
        
        $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Invoice balance", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, "$".number_format($venta->getSaldoPendiente(),2), '1', 1, 'C');
        
        $pdf->Cell(120, 5, "", '0', 0, 'L');
        $pdf->SetFont('Arial','B','12');
        $pdf->Cell(40, 5, "Account balance", '0', 0, 'L');
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(25, 5, "$".number_format($cliente->getSaldoPendiente(),2), '1', 1, 'C');
        
        $pdf->Ln(1);        
        $pdf->SetFont('Arial','B','10');
        $pdf->Cell(120, 6, "BILL TO", '1', 1, 'L',true);
        
        $pdf->Ln(2); 
        $pdf->SetFont('Arial','','12');
        $direccion  = $cliente->getNombre()."\n";
        $direccion .= $cliente->getCalle()."\n";
        $direccion .= $cliente->getCiudad()." ".$cliente->getEstado()." ".$cliente->getCodigopostal()."\n";
        $direccion .= $cliente->getTelefono()."\n";
        $direccion .= "Buyer: ".$ventaData['comprador'];
        $pdf->Cell(70, 21, $direccion, '0', 1, 'L');
        
        $pdf->Ln(1);
        
       $pdf->SetFont('Arial','B','10');
        $pdf->Cell(95, 7, "DESCRIPTION", '1', 0, 'C',true);
        $pdf->Cell(30, 7, "QUANTITY", '1', 0, 'C',true);
        $pdf->Cell(30, 7, "UNIT PRICE", '1', 0, 'C',true);
        $pdf->Cell(30, 7, "AMOUNT", '1', 1, 'C',true);
        
        $pdf->SetFont('Arial','','10');
        $montoTotal = 0;
        $totalCajas = 0;
        $rows = 0;
        $i=0;
        if(count($ventaDetalles) > 0){
            foreach($ventaDetalles as $detalle){
                $totalCajas += $detalle['cantidad'];
                $i++;
                if($i > 21){
                    // Salta pagina y crea encabezados de tabla
                    $pdf->Cell(95, 6, "DESCRIPTION", '1', 0, 'C',true);
                    $pdf->Cell(30, 6, "QUANTITY", '1', 0, 'C',true);
                    $pdf->Cell(30, 6, "UNIT PRICE", '1', 0, 'C',true);
                    $pdf->Cell(30, 6, "AMOUNT", '1', 1, 'C',true);
                $i=0;
                }
                
                $montoTotal += $detalle['cantidad'] * $detalle['precio']; 
                $rows++;
                $pdf->Cell(95, 6, $detalle['descripcion']." ".$detalle['tamano']." ".$detalle['um'], '1', 0, 'L');
                $pdf->Cell(30, 6, number_format($detalle['cantidad'],2), '1', 0, 'R');            
                $pdf->Cell(30, 6, "$ ".$detalle['precio'], '1', 0, 'R');
                $pdf->Cell(30, 6, "$ ".number_format($detalle['cantidad'] * $detalle['precio'],2), '1', 1, 'R');
            }
        }
        
        if($rows < 17){
            for($rows; $rows<=17; $rows++){
               $pdf->Cell(95, 6, "", '1', 0, 'C');
                $pdf->Cell(30, 6, "", '1', 0, 'C');
                $pdf->Cell(30, 6, "", '1', 0, 'C');
                $pdf->Cell(30, 6, "", '1', 1, 'C');
            }
        } 
        
         $pdf->SetFont('Arial','B','12');
         $pdf->Cell(95, 7, "TOTAL ", '1',0, 'R',true);
         $pdf->Cell(30, 7, number_format($totalCajas,2), '1', 0, 'R');
         $pdf->Cell(30, 7, "", '1', 0, 'C');
         $pdf->Cell(30, 7, "$ ".number_format($montoTotal,2), '1', 1, 'R');
         
         $pdf->SetFont('Arial','','8');
         $pdf->Ln(5);
         
         #Linea para imprimir comentarios capturados en venta.
         #$pdf->Cell(185, 15, "Notes:\n".$venta->mostrarComentariosInvoice(),'1', 1, 'L');
         
         $string = " Recibi de entera conformidad con cantidades, calidad\n y precio en los productos facturados en este documento.\n\n I received pursuant whole amounts, quality\n and price on products invoiced in this document.";
         $pdf->Cell(93, 15, $string,'TBL', 0, 'L');
         
         $string = "_____________________________\nSignature";
         $pdf->Cell(92, 15, $string,'TBR', 1, 'C');
         
         $pdf->SetFont('Arial','B','12');
         $pdf->Ln(5);
         $pdf->Cell(185, 5, "Thank you for your business",'0', 1, 'C');
        
         $string = "The perishable Agricultural commodities listed on this invoice are sold subject to the statutory trust authorized \n by section 5(c) of the perdishable Agriculture Commodities Act,1930 (7 U.S.C. 499e(c)).\n "
                 . "The seller of these commodities retains a trust claim over these commodities, all inventories of food or other products\n derived from these commodities, and any receivable or proceeds from the sale of these commodities until full payment is received.";
        
        $pdf->SetFont('Arial','','6');
        $pdf->Cell(185, 10, $string,'', 0, 'C');
        
        if($createFile){
            if(!is_dir(PATH_TEMP_DOCS."invoices/")){
                mkdir(PATH_TEMP_DOCS."invoices/",0777,true);
            }
            $pdf->Output(PATH_TEMP_DOCS."invoices/Invoice-".$ventaData['Venta'].".pdf","F");
            $this->pathInvoiceCreated = PATH_TEMP_DOCS."invoices/Invoice-".$ventaData['Venta'].".pdf";
        }else{
            $pdf->Output();
        }
    }
    
    public function getFileInvoiceCreated(){
        return $this->pathInvoiceCreated;
    }
}