<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */

class PagoForm extends Form {
    public function __construct() {
        $this->setActionForm('Payment.php');
        $this->setName('pago');
        $this->setMethod('post');
        $this->setClass('pago');      
        parent::__construct();
        $this->init();
    }

    public function init() {                      
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status',
        ));        

        $this->addElement(array(
            'type' => 'text',
            'name' => 'fecha',
            'label'=>'Fecha',
            'validators'=>array('date'),
            'required'=> true,
            'class'=>'_datetimepicker'
        ));                                     

        $this->addElement(array(
            'type' => 'select',
            'name' => 'forma_de_pago',
            'label'=>'Forma de pago',
            'multiOptions'=>$this->getListFormaPago(),
            'required'=>true
        ));                 

        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_operacion',
            'label'=>'Num. operacion',
            'required'=> false
        ));        

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'monto_original',
        ));       

        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'suma_de_pagos',
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'monto',
            'label'=>'Monto',
            'validators'=>array('double'),
            'required'=> true
        ));            
 
        
        $this->addElement(array(
            'type'=>'select',
            'name'=>'proveedor',
            'label'=>'Proveedor',
            'multiOptions'=>$this->getListProveedores(),
            'optionals'=>array('onchange'=>'getListFacturasProveedores()'),
            'required'=>false
        ));

        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'notas',
            'label'=>'Comentarios',
            'required'=> false
        ));        

        $this->addElement(array(
            'type'=>'submit',
            'name'=>'send',
            'value'=>$this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary'
        ));         
    }    

    public function addItem($idCompra) {
        $this->addElement(array(
            'type' => 'text',
            'name' => "pago[$idCompra]",
            'optionals'=>array('style'=>'text-align:right','readOnly'=>'true'),
            'class'=>'ammountPymt',
            'col-size-element'=>'12',
            'required'=>true
        ));       
    }    

    #Para pagos de consignas.
    #En info consigna guardo serializada la info de la consigna que se paga, esto es para no tener que consultar otra vez.
    #Especialmente consultar y obtener la info de liquidacion de la consigna es tardado.
    #Por eso de opto por guardar asi la info.

    public function addItems($elementId,$consignaData) {
        $this->addElement(array(
            'type' => 'text',
            'name' => "pago[$elementId]",
            'optionals'=>array('style'=>'width:90px;text-align:right'),
            'class'=>'ammountPymt',
            'required'=>true 
        ));

        $this->addElement(array('type'=>'hidden','name'=>"infoConsigna[$elementId]",'value'=>addslashes(serialize($consignaData))));
    }    

    public function setFacturasAPagar($facturas){
        if(!is_array($facturas)){return null;}
        foreach($facturas as $factura => $value){
            $this->addItem($factura);
            $this->setValueToElement($value, "pago[$factura]");
        }
    }    

    public function getListProveedores(){
        $repository = new VendorRepository();
        $result = $repository->getListSelectVendors();

        if ($result) {
            $array = array(null => 'Selecciona una opcion');
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function getListFormaPago(){
        $repository = new PagoRepository();
        $result = $repository->getListFormaPago();        

        if(count($result)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }    

    public function populate($data){     
        $tools = new Tools();
        if($tools->isValidaDateYYYMMDD($data['fecha'])){
            $data['fecha'] = $tools->setFormatDateToForm($data['fecha']);
        }

        parent::populate($data);
    }
}