<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class UserRepository extends EntityRepository {

    private $table = 'users';
    private $options = array(
        'user'=>null,
        'password'=>null,
        'nip'=>null,
        'master_key'=>null,
        'name'=>null,
        'last_name'=>null,
        'phone'=>null,        
        'email'=>null,
        'role'=>null,       
        'area_bakery_production_id'=>null,
        'store_id'=>null,
        'status'=>null,
    );
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
     public function getUsuario(){
        return $this->options['user'];
    }
    
    public function getContrasena(){
        return $this->options['password'];
    }
    
    public function getNombre(){
        return $this->options['name'];
    }
    
    public function getTable(){
        return $this->table;
    }

    public function save(array $data, $table = null) {
        $data['password'] = MD5($data['password']);
        if(is_array($data['store_id']) && count($data['store_id']) > 0){
            $data['store_id'] = trim(implode(',', $data['store_id']),',');
        }        
        
        if($data['role'] == '1' || $data['role'] == '2' || $data['role'] == '6'){
            $data['master_key'] = $data['nip'];
        }else{
            $data['master_key'] = '';
        }
        
        if(!isset($data['area_bakery_production_id']) || is_null($data['area_bakery_production_id'])){$data['area_bakery_production_id'] = 0;}
        
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {
        $currentData = $this->getById($id);
        if($data['password']!='' && $data['password']!=null){
            $data['password'] = MD5($data['password']);
        }else{
            unset($data['password']);
        }
        
        /*Si no es Mostrador*/
       if($data['role'] == '1' || $data['role'] == '2' || $data['role'] == '6'){ 
            /*Si al momento de hacer update de cambio de rol*/
            if($currentData['role'] != $data['role']){
                if(trim($data['nip'])=='' || $data['nip'] == null){
                    $data['master_key'] = $currentData['nip'];
                }else{
                    $data['master_key'] = $data['nip'];
                }              
            }
        }else{
            $data['master_key'] = '';
        }
        
        if(trim($data['nip']=='') || $data['nip']==null){ unset($data['nip']);}
        
        if(is_array($data['store_id']) && count($data['store_id']) > 0){
            $data['store_id'] = trim(implode(',', $data['store_id']),',');
        }       
        
        if(!isset($data['area_bakery_production_id']) || is_null($data['area_bakery_production_id'])){$data['area_bakery_production_id'] = 0;}
        
        foreach($data as $campo => $value){
            if(is_null($data[$campo])){unset($data[$campo]);}
        }
      
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
       return parent::isUsedInRecord($id, array(
           'sales_record' => 'creado_por',
           'special_orders'=>'creado_por',
           'store_request'=>'creado_por',
           'transfers'=>'creado_por',
           'outputs'=>'creado_por',
           'pagos'=>'creado_por',
           'physical_inventory'=>'creado_por',
           'purchases'=>'creado_por',
           'receivings'=>'creado_por',
           'receiving_store_requests'=>'creado_por',
           'returns'=>'creado_por',
           'shipment_store_requests'=>'creado_por'
           ));
    }

    public function getListRoles() {
        $select = "SELECT id,role FROM acl_roles";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['role'];
            }
            return $array;
        }
        return null;
    }
    
    public function getUsersByIds($ids){
        $select = "SELECT *,CONCAT(name,' ',last_name)as completeName FROM $this->table WHERE id IN($ids)";
        $result = $this->query($select);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListSelectUsers() {
        $select = "SELECT * FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['user'];
            }
            return $array;
        }
        return null;
    }
    
     public function getListUsers($options) {
        $store_id = null;
        $system_variable = null;
        
        $login = new Login();
        if($login->getRole() != '1'){
            $store_id = " AND find_in_set(store_id,'{$login->getStoreId()}')";
            $system_variable = " AND system_variable != '1'";
        }  
        
        $user_name = null;
        $role = null;
        $store = null;
        $status = " AND status = '1' ";
        $limit = null;
        
        if($options){
            if(trim($options['user']) !== ''){$user_name = " AND find_in_set(user,'{$options['user']}')";}

            if(isset($options['role'])){
                if(is_array($options['role']) && count($options['role']) > 0){
                    $roleIds = implode(',', $options['role']);
                    $role = " AND find_in_set(role,'{$roleIds}')";
                }else{
                    if(trim($options['role'])!= ''){$role = " AND find_in_set(role,'{$options['role']}')";}                     
                }           
            }       
            
            if(isset($options['store'])){
                if(is_array($options['store']) && count($options['store']) > 0){
                    $storeIds = implode(',', $options['store']);
                    $store = " AND find_in_set(store_id,'{$storeIds}')";
                }else{
                    if(trim($options['store'])!= ''){$store = " AND find_in_set(store_id,'{$options['store']}')";}                     
                }           
            }       

            if(isset($options['status']) && is_array($options['status']) && count($options['status']) > 0){
                $idsStatus = implode(',', $options['status']);
                $status = " AND find_in_set(status,'$idsStatus')";
            }  
            
            if(is_null($user_name) 
                    && is_null($role) 
                    && is_null($status)){$limit = " LIMIT 300";}
                    
            
        }else{
            $limit = " LIMIT 300";
        }       
        
        $select = "SELECT *,"
                . "CONCAT(name,' ',last_name)as complete_name,"
                . "fxGetStatusName(status,'User') as status_name, "
                . "fxGetRoleName(role) as role_name,"
                . "fxGetStoreName(store_id)as store_name "
                . "FROM $this->table "
                . "WHERE 1 = 1 $store_id $system_variable $user_name $role $store $status";
        
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus(){
        $query = "SELECT * FROM status_code WHERE operation = 'User'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            foreach($result as $status){
                $array[$status['code']] = $status['description'];
            }
            return $array;
        }
        return null;
    }
    
    public function storeStringToArray($users){
        $arrayUser = array();
        $users = explode(',', $users);
        foreach($users as $key => $user){
            $arrayUser[$user] = $user;
        }
        return $arrayUser;
    }
    
    public function getUserByNIP($nip){
        $query = "SELECT * FROM $this->table where nip = '$nip' AND status = '1' LIMIT 1 ";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function existUserName($username,$id){
        $query = "SELECT id FROM $this->table WHERE user = '$username' AND id != '{$id}'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return true;
        }
        return null;
    }
    
     public function existNIP($nip,$id){
        $query = "SELECT id FROM $this->table WHERE nip = '$nip' AND id != '{$id}'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return true;
        }
        return null;
    }
}