   <!-- SALES -->
    <?php 
    $current_date = date('Y-m-d');
    $date = new DateTime($current_date);    
    $sales_today = $date->format('m/d/Y');
    $date->sub(New DateInterval('P6D'));
    $sales_todaySub7Days = $date->format('m/d/Y');?>
    <div class="box-body">
      <div class="box box-primary">
        <div class="box-header">
            <i class="fa fa-line-chart"></i>
            <h3 class="box-title"><?php echo $_translator->_getTranslation('Ventas'); ?></h3>
        </div>
        <div class="box-body">
            <div class="col-lg-4 col-xs-12">
                <table id="tbl_sales_by_storeid" class="table">
                    <caption class="text-center"></caption>
                    <thead>
                    <tr>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Dia'); ?></th>
                        <th class="text-right"><?php echo $_translator->_getTranslation('Total'); ?></th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            <div id="chart_sales" class="col-lg-8 col-xs-12">
                <canvas id="canvas_chart_sales"></canvas>
            </div>
        </div>
      </div>
    </div>    
    <!-- END SALES -->    

    <!-- SPECIAL ORDERS -->
    <div class="box-body">
        <div class="col-lg-12 col-xs-12">
          <div class="box box-primary">
            <div class="box-header">
                <i class="fa fa-birthday-cake"></i>
                <h3 class="box-title"><?php echo $_translator->_getTranslation('Ordenes especiales'); ?></h3>
            </div>
            <div class="box-body">         
                <?php
                $date = new DateTime($current_date);
                $today = $date->format('Y-m-d');
                $todayFormated = $date->format('m/d/Y');
                $date->add(new DateInterval('P2D')); /*P2D = PLUS 2 DAYS*/
                $todayP2D = $date->format('Y-m-d');
                $todayP2DFormated =  $date->format('m/d/Y');

                $specialOrder = new SpecialOrderRepository();
                $list = $specialOrder->getListRequisitions(array('startDate'=>$today,'endDate'=>$todayP2D,'status_delivery'=>'1','status'=>'1'));?>
                
                <table id="tbl_special_orders" class="table">
                    <caption style="margin-bottom:10px"><?php echo $_translator->_getTranslation('Pedidos pendiente de entregar')." ".$_translator->_getTranslation('de')." ".$todayFormated." ".$_translator->_getTranslation('a')." ".$todayP2DFormated?></caption>
                    <thead>
                    <tr>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Pedido #'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Fecha de entrega'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Cliente'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Telefono'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Producido'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Accion'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                   <?php      
                    if($list){
                        foreach($list as $order){?>
                        <tr>
                            <td class="text-center"><?php echo $order['req_number'] ?></td>
                            <td class="text-center"><?php echo $order['delivery_date'] ?></td>
                            <td class="text-center"><?php echo $order['customerName'] ?></td>
                            <td class="text-center"><?php echo $order['phone'] ?></td>
                            <td class="text-center _statusProduction_<?php echo $order['id'] ?>"><?php if($order['status_production'] == '2'){?><i class="fa fa-check fa-2x text-olive"></i><?php }else{ echo ""; }?></td>
                            <td class="text-center" style='white-space:nowrap'>
                                <a class="btn btn-sm btn-default" href="SpecialOrder.php?action=edit&id=<?php echo $order['id']?>"><i class="fa fa-pencil fa-"></i></a>
                                <a class="btn btn-sm btn-default" href="#" onclick="javascript: void window.open('SpecialOrder.php?action=export&flag=pdf&id=<?php echo $order['id']?>','','width=700,height=500,status=1,scrollbars=1,resizable=1')"><i class="fa fa-file-pdf-o fa-"></i></a>                            

                            </td>
                        </tr><?php
                        }
                    }
                    ?>    
                    </tbody>
                </table>
            </div>
          </div>
        </div>    
    </div>
    <script>
        $(document).ready(function () {
            _salesChartByStoreId('<?php echo $sales_todaySub7Days ?>','<?php echo $sales_today ?>');
            $('#tbl_special_orders').DataTable({paginate:false,"order": [[ 1, "asc" ]],bInfo:false});
            $('#tbl_special_orders_filter').hide();   
        });
    </script>