<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */
class LocationAjax extends LocationRepository {
    
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options) {
        return $this->$request($options);
    }
    
    public function _getTranslation($text){
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options){
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }    
    
    public function getDataToEdit($options){
        $locationRepo = new LocationRepository();
        $data = $locationRepo->getById($options['id']);
        $data['action'] = 'edit';
        
        return array(
            'response'=>true,
            'locationData'=>$data
        );
    }
    
    public function deleteLocation($options){
        $locationRepo = new LocationRepository();
        
        if($locationRepo->delete($options['id'])){
            $this->flashmessenger->addMessage(array('success'=>'Locacion se elimino exitosamente.'));                
        }
        
        return array(
            'response'=>true
        );
    }
}