<?php    
        $settings = new SettingsRepository(); 
        $sucursales = $data['stores'];
        $areaName = $data['areaBakeryProduction'];
        $detalles = $data['data'];           
        $comentarios = $data['comments'];
        
        $pdf = new PDF();
        $options = $this->getOptions();
        if($settings->_get('id_production_for_panyo') == $options['area_bakery_production_id']){       
            $masasArray = $data['masasList'];
            
            foreach($data['dataPanyo'] as $key => $data){
                $pdf->AddPage('L','');                  
                $pdf->SetFillColor(245,245,245); 

                $pdf->SetFont('Arial','B','11');     
                $pdf->Cell(150, 12, $this->headerExcelReport, '0', 1, 'C');
                if($areaName){
                    $pdf->Cell(150, 4, 'Area: '.utf8_decode($areaName), '0', 1, 'C');
                }

                $pdf->Cell(275, 4, 'Generado: '.date('M/d/Y  g:i a'), '0', 1, 'C');
                $pdf->ln(5);      
        
                $masaNombre = $masasArray[$key];
                $totalCharolas = $data['total_pano_para_masa'];
                unset($data['total_pano_para_masa']);
                        
                $pdf->SetFont('Arial','B','12');   
                $pdf->Cell(100, 6, $masaNombre, '', 1, 'L'); /*no importa este ancho de columna*/                 
                
                $pdf->SetFont('Arial','B','8');   
                $pdf->Cell(50, 6, "Producto", 'B', 0, 'C');  
                
                foreach($sucursales as $store_id => $store_name){$pdf->Cell(18, 6, $store_name, 'B', 0, 'C');}        
                $pdf->Cell(12, 6, "Total", 'B', 1, 'C');        

                $pdf->SetFont('Arial','','8');                
                $fila = 2;
                $backgroundcolor = null;    
				$pageCout=0;
                foreach($data as $row){
					if($pageCout>23)
					{
						$pdf->AddPage('L','');
						$pdf->SetFont('Arial','B','8');    
						$pdf->Cell(50, 6, "Producto", 'B', 0, 'C');  
						foreach($sucursales as $store_id => $store_name){$pdf->Cell(12, 6, $store_name, 'B', 0, 'C');}        
						$pdf->Cell(15, 6, "Total", 'B', 1, 'C');
						$pageCout = 1;
						$pdf->SetFont('Arial','','8');    
					}
                    $total = 0;
                    if ($fila%2==0){$backgroundcolor = true;}
                    else{$backgroundcolor = null;}         

                    $pdf->Cell(50, 6, utf8_decode($row['description']), '0', 0, 'C',$backgroundcolor);
                    foreach($sucursales as $store_id => $store_name){                   
                        $total += $row[$store_id];                
                        $pdf->Cell(12, 6, $row[$store_id], '0', 0, 'C',$backgroundcolor);                                     
                    }  
                    $fila++;
                    $pdf->Cell(15, 6, $total, '0', 1, 'C',$backgroundcolor);
                }
                $pageCout++;
                $pdf->SetFont('Arial','B','12');   
                $pdf->Cell(100, 6,"Total $masaNombre: ".ceil($totalCharolas/4), '', 1, 'L');
            }
            
        }else{
            $pdf->AddPage('L','');                  
            $pdf->SetFillColor(245,245,245); 

            $pdf->SetFont('Arial','B','11');     
            $pdf->Cell(275, 12, $this->headerExcelReport, '0', 1, 'C');
            if($areaName){
                $pdf->Cell(275, 4, 'Area: '.utf8_decode($areaName), '0', 1, 'C');
            }

            $pdf->Cell(275, 4, 'Generado: '.date('F j, Y, g:i a'), '0', 1, 'C');
            $pdf->ln(5);      
                       
            $pdf->SetFont('Arial','B','8');    
            $pdf->Cell(50, 6, "Producto", 'B', 0, 'C');  
            foreach($sucursales as $store_id => $store_name){$pdf->Cell(12, 6, $store_name, 'B', 0, 'C');}        
            $pdf->Cell(15, 6, "Total", 'B', 1, 'C');        

            $pdf->SetFont('Arial','','8');                
            $fila = 2;
            $backgroundcolor = null;    
			$pageCout=0;
            foreach($detalles as $row){
				if($pageCout>23)
				{
					$pdf->AddPage('L','');
					$pdf->SetFont('Arial','B','8');    
					$pdf->Cell(50, 6, "Producto", 'B', 0, 'C');  
					foreach($sucursales as $store_id => $store_name){$pdf->Cell(12, 6, $store_name, 'B', 0, 'C');}        
					$pdf->Cell(15, 6, "Total", 'B', 1, 'C');
					$pageCout = 1;
					$pdf->SetFont('Arial','','8');    
				}
                $total = 0;
				$pdf->SetFont('Arial','','8');
                if ($fila%2==0){$backgroundcolor = true;}
                else{$backgroundcolor = null;}         

                $pdf->Cell(50, 6, utf8_decode($row['description']), '0', 0, 'C',$backgroundcolor);
                foreach($sucursales as $store_id => $store_name){                   
                    $total += $row[$store_id];
					if($row[$store_id] === '0')
					{$pdf->Cell(12, 6,'-', '0', 0, 'C',$backgroundcolor);}
					else{$pdf->Cell(12, 6,$row[$store_id], '0', 0, 'C',$backgroundcolor);}				
                }  
                $fila++;
				$pdf->SetFont('Arial','B','10');
                $pdf->Cell(15, 6, $total, '0', 1, 'C',$backgroundcolor);
				$pageCout++;
				
            }
        }
        
         if($comentarios){
             $pdf->AddPage('L','');           
             $pdf->SetFont('Arial','B','10');
             $pdf->Cell(93, 5, 'Notas', '', 1, 'L');
             $pdf->ln(5);
            foreach($comentarios as $comentario){
                $pdf->SetFont('Arial','B','8');
                $pdf->Cell(93, 5, $comentario['store_name'], 'B', 1, 'L');
                $pdf->SetFont('Arial','','8');
                $pdf->Multicell(93,4,  $comentario['comments'], '0', 1, 'L');
                $pdf->ln(2);
            }            
        }       
        
        /*BLOQUEAR PEDIDOS EN EL RANGO DE FECHA SELECCIONADO*/  
        $areaPanaderia = $settings->_get('id_area_for_panaderia');
        
        $repoStoreRequest = new StoreRequestRepository();
        $this->options['area_id'] = $areaPanaderia;
        $repoStoreRequest->setStatusInProcessByRangeDate($this->getOptions());
        
        if($this->saveFile == true){    
            $pdf->Output($this->getTempFolder()."/".$this->getNombreArchivo().".pdf","F");
        }else{
            $pdf->Output();
        }
        
        
        
       

    

